<?php
$page_title = "অফার যোগ/এডিট";
require_once 'includes/auth_check.php';

$offer = ['id' => '', 'offer_name' => '', 'operator' => '', 'price' => '', 'offer_type' => '', 'description' => '', 'status' => 'Active'];
$form_action = 'add_edit_offer.php';
$is_edit_mode = false;

if (isset($_GET['id'])) {
    $is_edit_mode = true;
    $offer_id = $_GET['id'];
    $form_action .= "?id=$offer_id";
    $stmt = $conn->prepare("SELECT * FROM offers WHERE id = ?");
    $stmt->bind_param("i", $offer_id);
    $stmt->execute();
    $offer = $stmt->get_result()->fetch_assoc();
    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $offer_name = $_POST['offer_name'];
    $operator = $_POST['operator'];
    $price = $_POST['price'];
    $offer_type = $_POST['offer_type'];
    $description = $_POST['description'];
    $status = $_POST['status'];

    if ($is_edit_mode) {
        $stmt = $conn->prepare("UPDATE offers SET offer_name=?, operator=?, price=?, offer_type=?, description=?, status=? WHERE id=?");
        $stmt->bind_param("ssdsssi", $offer_name, $operator, $price, $offer_type, $description, $status, $offer_id);
    } else {
        $stmt = $conn->prepare("INSERT INTO offers (offer_name, operator, price, offer_type, description, status) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssdsss", $offer_name, $operator, $price, $offer_type, $description, $status);
    }
    
    if ($stmt->execute()) {
        header("Location: offers.php");
        exit;
    }
    $stmt->close();
}

include 'includes/header.php';
?>
<div class="container-fluid">
    <a href="offers.php" class="btn btn-secondary mb-3"><i class="fas fa-arrow-left"></i> সকল অফারে ফিরে যান</a>
    <h2><?php echo $is_edit_mode ? 'অফার এডিট করুন' : 'নতুন অফার যোগ করুন'; ?></h2>
    <div class="card">
        <div class="card-body">
            <form method="POST" action="<?php echo $form_action; ?>">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">অফারের নাম</label>
                        <input type="text" name="offer_name" class="form-control" value="<?php echo htmlspecialchars($offer['offer_name']); ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">অপারেটর</label>
                        <select name="operator" class="form-select" required>
                            <option value="Grameenphone" <?php if($offer['operator'] == 'Grameenphone') echo 'selected'; ?>>Grameenphone</option>
                            <option value="Robi" <?php if($offer['operator'] == 'Robi') echo 'selected'; ?>>Robi</option>
                            <option value="Banglalink" <?php if($offer['operator'] == 'Banglalink') echo 'selected'; ?>>Banglalink</option>
                            <option value="Airtel" <?php if($offer['operator'] == 'Airtel') echo 'selected'; ?>>Airtel</option>
                            <option value="Teletalk" <?php if($offer['operator'] == 'Teletalk') echo 'selected'; ?>>Teletalk</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">মূল্য (৳)</label>
                        <input type="number" step="0.01" name="price" class="form-control" value="<?php echo htmlspecialchars($offer['price']); ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">অফারের ধরন</label>
                        <select name="offer_type" class="form-select" required>
                            <option value="Internet" <?php if($offer['offer_type'] == 'Internet') echo 'selected'; ?>>Internet</option>
                            <option value="Minute" <?php if($offer['offer_type'] == 'Minute') echo 'selected'; ?>>Minute</option>
                            <option value="Combo" <?php if($offer['offer_type'] == 'Combo') echo 'selected'; ?>>Combo</option>
                        </select>
                    </div>
                    <div class="col-12 mb-3">
                        <label class="form-label">বিবরণ</label>
                        <textarea name="description" class="form-control"><?php echo htmlspecialchars($offer['description']); ?></textarea>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">স্ট্যাটাস</label>
                        <select name="status" class="form-select">
                            <option value="Active" <?php if($offer['status'] == 'Active') echo 'selected'; ?>>Active</option>
                            <option value="Inactive" <?php if($offer['status'] == 'Inactive') echo 'selected'; ?>>Inactive</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn btn-success"><?php echo $is_edit_mode ? 'আপডেট করুন' : 'সেভ করুন'; ?></button>
            </form>
        </div>
    </div>
</div>
<?php
include 'includes/footer.php';
$conn->close();
?>