<?php
require_once 'includes/db_connect.php';
if (!isset($_SESSION["user_id"])) { header("location: login.php"); exit; }

$user_id = $_SESSION['user_id'];
$message = '';

// Check the settings table to see if auto payment is enabled by the admin
$auto_payment_enabled_res = $conn->query("SELECT setting_value FROM settings WHERE setting_name = 'auto_payment_enabled'");
$auto_payment_enabled = ($auto_payment_enabled_res && $auto_payment_enabled_res->num_rows > 0) ? $auto_payment_enabled_res->fetch_assoc()['setting_value'] : '0';

// Handle submission of the MANUAL payment form
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['manual_submit'])) {
    $amount = (float)$_POST['amount'];
    $method = $_POST['method'];
    $transaction_id = trim($_POST['transaction_id']);

    if ($amount > 0 && !empty($method) && !empty($transaction_id)) {
        $stmt = $conn->prepare("INSERT INTO add_balance_requests (user_id, amount, method, transaction_id) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("idss", $user_id, $amount, $method, $transaction_id);
        if ($stmt->execute()) {
            $message = '<div class="alert alert-success mt-3">আপনার ম্যানুয়াল রিকুয়েস্টটি সফলভাবে জমা হয়েছে। এডমিন এটি যাচাই করার পর আপনার ব্যালেন্স আপডেট হয়ে যাবে।</div>';
        } else {
            $message = '<div class="alert alert-danger mt-3">রিকুয়েস্ট জমা দিতে সমস্যা হয়েছে।</div>';
        }
    } else {
        $message = '<div class="alert alert-danger mt-3">অনুগ্রহ করে ম্যানুয়াল ফর্মের সব তথ্য সঠিকভাবে পূরণ করুন।</div>';
    }
}

// Fetch active MANUAL payment methods to display in the list
$payment_methods = $conn->query("SELECT * FROM payment_methods WHERE status = 'Active'");
$conn->close();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>এড ব্যালেন্স</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { background-color: #f4f7fa; font-family: 'Noto Sans Bengali', sans-serif; }
        .method-item { border: 1px solid #e9ecef; border-radius: 8px; padding: 15px; margin-bottom: 10px; display: flex; align-items: center; justify-content: space-between; background-color: #fff; }
        .method-logo { width: 40px; margin-right: 15px; }
        .copy-btn { cursor: pointer; }
        .copied-toast { position: fixed; bottom: 20px; left: 50%; transform: translateX(-50%); background-color: #212529; color: white; padding: 10px 20px; border-radius: 20px; z-index: 1050; display: none; }
    </style>
</head>
<body>
<div class="container my-4" style="max-width: 500px;">
    <div class="d-flex align-items-center mb-3">
        <a href="index.php" class="text-dark fs-4 me-3 text-decoration-none"><i class="fas fa-arrow-left"></i></a>
        <h3 class="mb-0">এড ব্যালেন্স</h3>
    </div>
    
    <?php if(!empty($message)) echo $message; ?>

    <?php if ($auto_payment_enabled == '1'): ?>
    <div class="card p-3 mb-4 shadow-sm">
        <h5 class="mb-3"><i class="fas fa-bolt text-warning me-2"></i>স্বয়ংক্রিয়ভাবে ব্যালেন্স যোগ করুন</h5>
        <form action="initiate_payment.php" method="POST">
            <div class="mb-3">
                <label class="form-label">টাকার পরিমাণ</label>
                <input type="number" name="amount" class="form-control" placeholder="কত টাকা যোগ করতে চান" required>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-danger">
                    <img src="https://i.ibb.co/d2W3n5R/bkash.png" width="24" class="me-2" style="vertical-align: middle;"> বিকাশ দিয়ে পেমেন্ট করুন
                </button>
            </div>
        </form>
    </div>
    <?php endif; ?>

    <div class="card p-3 shadow-sm">
        <h5 class="mb-2"><i class="fas fa-hand-holding-usd text-info me-2"></i>ম্যানুয়ালি ব্যালেন্স যোগ করুন</h5>
        <p class="text-center text-muted small">টাকা পাঠানোর জন্য নিচের নম্বর ব্যবহার করুন এবং তথ্য জমা দিন। নম্বরটি কপি করতে নম্বরের উপর ক্লিক করুন।</p>
        
        <div class="payment-methods-list my-3">
            <?php if ($payment_methods && $payment_methods->num_rows > 0): ?>
                <?php while($method = $payment_methods->fetch_assoc()): ?>
                <div class="method-item">
                    <div class="d-flex align-items-center">
                        <img src="<?php echo htmlspecialchars($method['logo_url']); ?>" alt="<?php echo htmlspecialchars($method['method_name']); ?>" class="method-logo">
                        <div>
                            <strong class="d-block"><?php echo htmlspecialchars($method['method_name']); ?></strong>
                            <span class="text-muted"><?php echo htmlspecialchars($method['account_type']); ?></span>
                        </div>
                    </div>
                    <div class="text-end">
                        <strong class="d-block copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($method['account_number']); ?>')"><?php echo htmlspecialchars($method['account_number']); ?></strong>
                        <small class="text-primary copy-btn" onclick="copyToClipboard('<?php echo htmlspecialchars($method['account_number']); ?>')">কপি করুন <i class="fas fa-copy"></i></small>
                    </div>
                </div>
                <?php endwhile; ?>
            <?php else: ?>
                <p class="text-center">এডমিন এখনো কোনো ম্যানুয়াল পেমেন্ট নম্বর যোগ করেনি।</p>
            <?php endif; ?>
        </div>
        <hr>
        <h5 class="mt-2">লেনদেনের তথ্য জমা দিন</h5>
        <form method="POST" action="add_balance.php">
            <div class="mb-3">
                <label class="form-label">টাকার পরিমাণ</label>
                <input type="number" step="0.01" name="amount" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">কোন মাধ্যমে টাকা পাঠিয়েছেন?</label>
                <select name="method" class="form-select" required>
                    <option value="">-- বাছাই করুন --</option>
                    <?php if ($payment_methods) mysqli_data_seek($payment_methods, 0); ?>
                    <?php while($method = $payment_methods->fetch_assoc()): ?>
                    <option value="<?php echo htmlspecialchars($method['method_name']); ?>"><?php echo htmlspecialchars($method['method_name']); ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="mb-3">
                <label class="form-label">ট্রানজেকশন আইডি (TrxID)</label>
                <input type="text" name="transaction_id" class="form-control" required>
            </div>
            <button type="submit" name="manual_submit" class="btn btn-primary w-100">রিকুয়েস্ট জমা দিন</button>
        </form>
    </div>
</div>

<div class="copied-toast" id="copiedToast">নম্বরটি কপি করা হয়েছে!</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        var toast = document.getElementById('copiedToast');
        toast.style.display = 'block';
        setTimeout(function(){ toast.style.display = 'none'; }, 2000);
    }, function(err) {
        alert('দুঃখিত, নম্বরটি কপি করা যায়নি।');
    });
}
</script>
</body>
</html>