<?php
// 1. Include the database connection file
require_once 'includes/db_connect.php';

// 2. Fetch all settings from the database for branding
$settings_res = $conn->query("SELECT * FROM settings");
$settings = [];
while ($row = $settings_res->fetch_assoc()) {
    $settings[$row['setting_name']] = $row['setting_value'];
}

// 3. Handle Registration Form Submission Logic
$message = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $full_name = trim($_POST['full_name']);
    $mobile = trim($_POST['mobile']);
    $password = $_POST['password'];

    // --- Server-Side Validation ---
    if (empty($full_name) || empty($mobile) || empty($password)) {
        $message = '<div class="alert alert-danger">অনুগ্রহ করে সব ঘর পূরণ করুন।</div>';
    } elseif (strlen($password) < 6) {
        $message = '<div class="alert alert-danger">পাসওয়ার্ড অবশ্যই কমপক্ষে ৬ অক্ষরের হতে হবে।</div>';
    } else {
        // Check if the mobile number already exists
        $stmt = $conn->prepare("SELECT id FROM users WHERE mobile = ?");
        $stmt->bind_param("s", $mobile);
        $stmt->execute();
        $stmt->store_result();
        
        if ($stmt->num_rows > 0) {
            $message = '<div class="alert alert-danger">এই মোবাইল নম্বরটি bereits ব্যবহৃত হয়েছে। অন্য একটি নম্বর দিন।</div>';
        } else {
            // If the mobile number is unique, proceed to create the account
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            $stmt_insert = $conn->prepare("INSERT INTO users (full_name, mobile, password) VALUES (?, ?, ?)");
            $stmt_insert->bind_param("sss", $full_name, $mobile, $hashed_password);
            
            if ($stmt_insert->execute()) {
                $message = '<div class="alert alert-success">রেজিস্ট্রেশন সফল হয়েছে। এখন আপনি লগইন করতে পারেন।</div>';
            } else {
                $message = '<div class="alert alert-danger">একটি অপ্রত্যাশিত সমস্যা হয়েছে। অনুগ্রহ করে আবার চেষ্টা করুন।</div>';
            }
            $stmt_insert->close();
        }
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>রেজিস্ট্রেশন - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <link rel="icon" href="<?php echo htmlspecialchars($settings['site_favicon']); ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f0f2f5; font-family: 'Noto Sans Bengali', sans-serif; }
        .form-container { 
            max-width: 400px; 
            margin: 60px auto; 
            padding: 30px; 
            background: #fff; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.1); 
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-container">
            
            <div class="text-center mb-4">
                <a href="index.php">
                    <img src="<?php echo htmlspecialchars($settings['site_logo']); ?>" alt="Site Logo" style="max-height: 60px;">
                </a>
            </div>
            
            <div class="text-center">
                <h2>নতুন একাউন্ট তৈরি করুন</h2>
                <p class="text-muted">আপনার তথ্য দিয়ে রেজিস্ট্রেশন সম্পন্ন করুন।</p>
            </div>

            <?php if(!empty($message)) echo $message; ?>
            
            <form action="register.php" method="post" class="mt-4">
                <div class="form-floating mb-3">
                    <input type="text" name="full_name" class="form-control" id="floatingName" placeholder="আপনার সম্পূর্ণ নাম" required>
                    <label for="floatingName">আপনার সম্পূর্ণ নাম</label>
                </div>
                <div class="form-floating mb-3">
                    <input type="tel" name="mobile" class="form-control" id="floatingMobile" placeholder="মোবাইল নম্বর" required>
                    <label for="floatingMobile">মোবাইল নম্বর</label>
                </div>
                <div class="form-floating mb-3">
                    <input type="password" name="password" class="form-control" id="floatingPassword" placeholder="পাসওয়ার্ড" required>
                    <label for="floatingPassword">পাসওয়ার্ড (কমপক্ষে ৬ অক্ষর)</label>
                </div>
                <div class="text-start my-3">
                    <p class="small text-muted">একাউন্ট তৈরি করার মাধ্যমে আপনি আমাদের <a href="terms.php" target="_blank">শর্তাবলী</a> এবং <a href="privacy.php" target="_blank">গোপনীয় নীতিমালা</a>-তে সম্মত হচ্ছেন।</p>
                </div>
                <button type="submit" class="btn btn-primary w-100 py-2">রেজিস্টার</button>
            </form>
            <div class="mt-3 text-center">
                <p>ইতিমধ্যে একাউন্ট আছে? <a href="login.php">এখানে লগইন করুন</a></p>
            </div>
        </div>
    </div>
</body>
</html>