<?php
// --- DEBUGGING: Force display of all errors ---
// This will replace the HTTP 500 error with the real PHP error message.
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// ---------------------------------------------

require_once 'includes/db_connect.php';
require_once 'includes/mock_api.php';

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $mobile = trim($_POST['mobile']);

    if (empty($mobile)) {
        $message = '<div class="alert alert-danger">অনুগ্রহ করে আপনার মোবাইল নম্বর দিন।</div>';
    } else {
        // Check if the user exists in the database
        $stmt = $conn->prepare("SELECT id FROM users WHERE mobile = ?");
        $stmt->bind_param("s", $mobile);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $otp = rand(100000, 999999); // Generate a 6-digit OTP
            $hashed_otp = password_hash($otp, PASSWORD_DEFAULT);
            
            // Store the hashed OTP in the 'password_resets' table
            $stmt_insert = $conn->prepare("INSERT INTO password_resets (mobile, otp_code) VALUES (?, ?)");
            $stmt_insert->bind_param("ss", $mobile, $hashed_otp);
            
            // Execute and check for errors
            if ($stmt_insert->execute()) {
                // "Send" the OTP using our mock API
                if (sendOtpAPI($mobile, $otp)) {
                    // Redirect to the OTP verification page
                    header("location: reset_password.php?mobile=" . urlencode($mobile));
                    exit;
                } else {
                    $message = '<div class="alert alert-danger">OTP পাঠাতে সমস্যা হয়েছে।</div>';
                }
            } else {
                // This will catch errors if the 'password_resets' table is missing or has a problem.
                $message = '<div class="alert alert-danger">ডাটাবেজে OTP সংরক্ষণ করতে সমস্যা হয়েছে। এডমিনের সাথে যোগাযোগ করুন।</div>';
            }

        } else {
            $message = '<div class="alert alert-danger">এই মোবাইল নম্বরটি আমাদের সিস্টেমে রেজিস্টার্ড নয়।</div>';
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পাসওয়ার্ড রিসেট</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body style="background-color:#f0f2f5;">
    <div class="container" style="max-width:400px; margin-top:100px;">
        <div class="card p-4">
            <h3 class="text-center">পাসওয়ার্ড রিসেট</h3>
            <p class="text-center text-muted">আপনার রেজিস্টার্ড মোবাইল নম্বরটি দিন</p>
            
            <?php if(!empty($message)) echo $message; ?>
            
            <form method="POST" action="forgot_password.php" class="mt-3">
                <div class="mb-3">
                    <label class="form-label">মোবাইল নম্বর</label>
                    <input type="tel" name="mobile" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary w-100">OTP পাঠান</button>
                <div class="text-center mt-3">
                    <a href="login.php">লগইন পেজে ফিরে যান</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>