<?php
require_once 'includes/db_connect.php';
if (!isset($_SESSION["user_id"])) { header("location: login.php"); exit; }

$user_id = $_SESSION['user_id'];
$pin_message = '';

$user_details_stmt = $conn->prepare("SELECT transaction_pin FROM users WHERE id = ?");
$user_details_stmt->bind_param("i", $user_id);
$user_details_stmt->execute();
$user = $user_details_stmt->get_result()->fetch_assoc();
$has_pin_set = !is_null($user['transaction_pin']);

if (isset($_POST['update_pin'])) {
    $new_pin = $_POST['new_pin'];
    $confirm_pin = $_POST['confirm_pin'];
    if (!is_numeric($new_pin) || strlen($new_pin) != 4) {
        $pin_message = '<div class="alert alert-danger">পিন অবশ্যই ৪-সংখ্যার একটি নম্বর হতে হবে।</div>';
    } elseif ($new_pin !== $confirm_pin) {
        $pin_message = '<div class="alert alert-danger">নতুন পিন এবং কনফার্ম পিন মেলেনি।</div>';
    } else {
        if ($has_pin_set) {
            $current_pin = $_POST['current_pin'];
            if (!password_verify($current_pin, $user['transaction_pin'])) {
                $pin_message = '<div class="alert alert-danger">আপনার বর্তমান পিন সঠিক নয়।</div>';
            }
        }
        if (empty($pin_message)) {
            $hashed_pin = password_hash($new_pin, PASSWORD_DEFAULT);
            $update_stmt = $conn->prepare("UPDATE users SET transaction_pin = ? WHERE id = ?");
            $update_stmt->bind_param("si", $hashed_pin, $user_id);
            if ($update_stmt->execute()) {
                $pin_message = '<div class="alert alert-success">আপনার লেনদেনের পিন সফলভাবে সেট/পরিবর্তন হয়েছে।</div>';
                $has_pin_set = true;
            }
        }
    }
}
?>
<!DOCTYPE html><html lang="bn"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>পিন ম্যানেজমেন্ট</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"></head>
<body style="background-color: #f0f2f5;"><div class="container" style="max-width: 500px; margin-top: 50px;"><div class="card p-4">
    <div class="d-flex align-items-center mb-3"><a href="index.php" class="text-dark fs-4 me-3 text-decoration-none"><i class="fas fa-arrow-left"></i></a><h3 class="mb-0"><?php echo $has_pin_set ? 'পিন পরিবর্তন করুন' : 'নতুন পিন সেট করুন'; ?></h3></div>
    <?php echo $pin_message; ?>
    <form method="POST" class="mt-3">
        <?php if ($has_pin_set): ?>
            <div class="mb-3"><label class="form-label">বর্তমান পিন</label><input type="password" name="current_pin" class="form-control" inputmode="numeric" maxlength="4" required></div>
        <?php endif; ?>
        <div class="mb-3"><label class="form-label">নতুন ৪-সংখ্যার পিন</label><input type="password" name="new_pin" class="form-control" inputmode="numeric" maxlength="4" required></div>
        <div class="mb-3"><label class="form-label">নতুন পিন নিশ্চিত করুন</label><input type="password" name="confirm_pin" class="form-control" inputmode="numeric" maxlength="4" required></div>
        <button type="submit" name="update_pin" class="btn btn-primary w-100"><?php echo $has_pin_set ? 'পরিবর্তন করুন' : 'পিন সেট করুন'; ?></button>
    </form>
</div></div></body></html>