<?php
$page_title = "হেল্পলাইন সেটিংস";
require_once 'includes/auth_check.php';
$message = '';

// Handle form submission to update settings
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings = [
        'whatsapp_number' => $_POST['whatsapp_number'],
        'telegram_link'   => $_POST['telegram_link'],
        'email_address'   => $_POST['email_address'],
        'phone_number'    => $_POST['phone_number']
    ];

    foreach ($settings as $name => $value) {
        $stmt = $conn->prepare("UPDATE helpline SET setting_value = ? WHERE setting_name = ?");
        $stmt->bind_param("ss", $value, $name);
        $stmt->execute();
    }
    $message = '<div class="alert alert-success">হেল্পলাইন তথ্য সফলভাবে আপডেট হয়েছে।</div>';
}

// Fetch current settings from the database
$settings_db = $conn->query("SELECT * FROM helpline");
$current_settings = [];
while ($row = $settings_db->fetch_assoc()) {
    $current_settings[$row['setting_name']] = $row['setting_value'];
}

include 'includes/header.php';
?>
<div class="container-fluid">
    <h2 class="mb-4">হেল্পলাইন সেটিংস</h2>
    <?php echo $message; ?>
    <div class="card">
        <div class="card-body">
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">হোয়াটসঅ্যাপ নম্বর</label>
                    <input type="text" name="whatsapp_number" class="form-control" value="<?php echo htmlspecialchars($current_settings['whatsapp_number'] ?? ''); ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">টেলিগ্রাম লিংক</label>
                    <input type="text" name="telegram_link" class="form-control" value="<?php echo htmlspecialchars($current_settings['telegram_link'] ?? ''); ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">ইমেইল এড্রেস</label>
                    <input type="email" name="email_address" class="form-control" value="<?php echo htmlspecialchars($current_settings['email_address'] ?? ''); ?>">
                </div>
                <div class="mb-3">
                    <label class="form-label">ফোন নম্বর</label>
                    <input type="text" name="phone_number" class="form-control" value="<?php echo htmlspecialchars($current_settings['phone_number'] ?? ''); ?>">
                </div>
                <button type="submit" class="btn btn-primary">সেভ করুন</button>
            </form>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; $conn->close(); ?>