<?php
$page_title = "পেমেন্ট মেথড যোগ/এডিট";
require_once 'includes/auth_check.php';

$method = ['id' => '', 'method_name' => '', 'account_number' => '', 'account_type' => '', 'logo_url' => '', 'status' => 'Active'];
$is_edit_mode = false;
if (isset($_GET['id'])) {
    $is_edit_mode = true;
    $id = (int)$_GET['id'];
    $method = $conn->query("SELECT * FROM payment_methods WHERE id = $id")->fetch_assoc();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $method_name = $_POST['method_name']; $account_number = $_POST['account_number']; $account_type = $_POST['account_type']; $logo_url = $_POST['logo_url']; $status = $_POST['status'];
    if ($is_edit_mode) {
        $stmt = $conn->prepare("UPDATE payment_methods SET method_name=?, account_number=?, account_type=?, logo_url=?, status=? WHERE id=?");
        $stmt->bind_param("sssssi", $method_name, $account_number, $account_type, $logo_url, $status, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO payment_methods (method_name, account_number, account_type, logo_url, status) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $method_name, $account_number, $account_type, $logo_url, $status);
    }
    if ($stmt->execute()) { header("Location: payment_methods.php"); exit; }
}

include 'includes/header.php';
?>
<div class="container-fluid">
    <a href="payment_methods.php" class="btn btn-secondary mb-3"><i class="fas fa-arrow-left"></i> ফিরে যান</a>
    <h2><?php echo $is_edit_mode ? 'মেথড এডিট করুন' : 'নতুন মেথড যোগ করুন'; ?></h2>
    <div class="card"><div class="card-body">
        <form method="POST">
            <div class="mb-3"><label class="form-label">মেথডের নাম</label><input type="text" name="method_name" class="form-control" value="<?php echo htmlspecialchars($method['method_name']); ?>" required></div>
            <div class="mb-3"><label class="form-label">একাউন্ট নম্বর</label><input type="text" name="account_number" class="form-control" value="<?php echo htmlspecialchars($method['account_number']); ?>" required></div>
            <div class="mb-3"><label class="form-label">একাউন্টের ধরন</label><input type="text" name="account_type" class="form-control" value="<?php echo htmlspecialchars($method['account_type']); ?>" placeholder="e.g., Personal, Agent" required></div>
            <div class="mb-3"><label class="form-label">লোগোর URL</label><input type="text" name="logo_url" class="form-control" value="<?php echo htmlspecialchars($method['logo_url']); ?>"></div>
            <div class="mb-3"><label class="form-label">স্ট্যাটাস</label><select name="status" class="form-select"><option value="Active" <?php if($method['status'] == 'Active') echo 'selected'; ?>>Active</option><option value="Inactive" <?php if($method['status'] == 'Inactive') echo 'selected'; ?>>Inactive</option></select></div>
            <button type="submit" class="btn btn-success"><?php echo $is_edit_mode ? 'আপডেট করুন' : 'সেভ করুন'; ?></button>
        </form>
    </div></div>
</div>
<?php include 'includes/footer.php'; $conn->close(); ?>