<?php
require_once 'includes/db_connect.php';
if (!isset($_SESSION["user_id"])) { header("location: login.php"); exit; }

// Fetch helpline settings from the database
$settings_db = $conn->query("SELECT * FROM helpline");
$contact_info = [];
while ($row = $settings_db->fetch_assoc()) {
    $contact_info[$row['setting_name']] = $row['setting_value'];
}
$conn->close();

$whatsapp_number = $contact_info['whatsapp_number'] ?? '';
$telegram_link   = $contact_info['telegram_link'] ?? '';
$email_address   = $contact_info['email_address'] ?? '';
$phone_number    = $contact_info['phone_number'] ?? '';
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>হেল্পলাইন - সহজ রিচার্জ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { background-color: #f4f7fa; font-family: 'Noto Sans Bengali', sans-serif; }
        .contact-card { background-color: white; border: none; border-radius: 1rem; box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05); transition: transform 0.2s; }
        .contact-card:hover { transform: translateY(-5px); }
        .contact-icon { font-size: 2rem; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; }
        .bg-whatsapp { background-color: #25D366; } .bg-telegram { background-color: #0088cc; } .bg-email { background-color: #EA4335; } .bg-phone { background-color: #0d6efd; }
    </style>
</head>
<body>
    <div class="container my-4" style="max-width: 500px;">
        <div class="d-flex align-items-center mb-4">
            <a href="index.php" class="text-dark fs-4 me-3 text-decoration-none"><i class="fas fa-arrow-left"></i></a>
            <h3 class="mb-0">হেল্পলাইন ও সাপোর্ট</h3>
        </div>
        <div class="card p-3">
            <p class="text-center text-muted">যেকোনো প্রয়োজনে বা সমস্যার জন্য নিচের যেকোনো মাধ্যমে আমাদের সাথে যোগাযোগ করুন।</p>
            <hr>
            
            <?php if (!empty($whatsapp_number)): ?>
            <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $whatsapp_number); ?>" target="_blank" class="text-decoration-none text-dark">
                <div class="card contact-card p-3 mb-3"><div class="d-flex align-items-center"><div class="contact-icon bg-whatsapp me-3"><i class="fab fa-whatsapp"></i></div><div><strong class="d-block">WhatsApp</strong><span><?php echo htmlspecialchars($whatsapp_number); ?></span></div></div></div>
            </a>
            <?php endif; ?>
            
            <?php if (!empty($telegram_link)): ?>
            <a href="<?php echo htmlspecialchars($telegram_link); ?>" target="_blank" class="text-decoration-none text-dark">
                <div class="card contact-card p-3 mb-3"><div class="d-flex align-items-center"><div class="contact-icon bg-telegram me-3"><i class="fab fa-telegram-plane"></i></div><div><strong class="d-block">Telegram</strong><span>আমাদের টেলিগ্রাম চ্যানেলে যোগ দিন</span></div></div></div>
            </a>
            <?php endif; ?>

            <?php if (!empty($email_address)): ?>
            <a href="mailto:<?php echo htmlspecialchars($email_address); ?>" class="text-decoration-none text-dark">
                <div class="card contact-card p-3 mb-3"><div class="d-flex align-items-center"><div class="contact-icon bg-email me-3"><i class="fas fa-envelope"></i></div><div><strong class="d-block">Email Support</strong><span><?php echo htmlspecialchars($email_address); ?></span></div></div></div>
            </a>
            <?php endif; ?>

            <?php if (!empty($phone_number)): ?>
            <a href="tel:<?php echo htmlspecialchars($phone_number); ?>" class="text-decoration-none text-dark">
                <div class="card contact-card p-3"><div class="d-flex align-items-center"><div class="contact-icon bg-phone me-3"><i class="fas fa-phone-alt"></i></div><div><strong class="d-block">Phone Call</strong><span><?php echo htmlspecialchars($phone_number); ?></span></div></div></div>
            </a>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>