<?php
require_once 'includes/db_connect.php';
if (!isset($_SESSION["user_id"])) { header("location: login.php"); exit; }

$user_id = $_SESSION['user_id'];
$password_message = '';

if (isset($_POST['change_password'])) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    $stmt = $conn->prepare("SELECT password FROM users WHERE id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $user = $stmt->get_result()->fetch_assoc();
    $hashed_password = $user['password'];

    if (!password_verify($current_password, $hashed_password)) {
        $password_message = '<div class="alert alert-danger">আপনার বর্তমান পাসওয়ার্ড সঠিক নয়।</div>';
    } elseif ($new_password != $confirm_password) {
        $password_message = '<div class="alert alert-danger">নতুন পাসওয়ার্ড দুটি মেলেনি।</div>';
    } elseif (strlen($new_password) < 6) {
        $password_message = '<div class="alert alert-danger">নতুন পাসওয়ার্ড কমপক্ষে ৬ অক্ষরের হতে হবে।</div>';
    } else {
        $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt_update = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
        $stmt_update->bind_param("si", $new_hashed_password, $user_id);
        if ($stmt_update->execute()) {
            $password_message = '<div class="alert alert-success">পাসওয়ার্ড সফলভাবে পরিবর্তন হয়েছে।</div>';
        }
    }
}
?>
<!DOCTYPE html><html lang="bn"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width, initial-scale=1.0"><title>পাসওয়ার্ড পরিবর্তন</title><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"></head>
<body style="background-color: #f0f2f5;"><div class="container" style="max-width: 500px; margin-top: 50px;"><div class="card p-4">
    <div class="d-flex align-items-center mb-3"><a href="index.php" class="text-dark fs-4 me-3 text-decoration-none"><i class="fas fa-arrow-left"></i></a><h3 class="mb-0">পাসওয়ার্ড পরিবর্তন করুন</h3></div>
    <?php echo $password_message; ?>
    <form method="POST" class="mt-3">
        <div class="mb-3"><label class="form-label">বর্তমান পাসওয়ার্ড</label><input type="password" name="current_password" class="form-control" required></div>
        <div class="mb-3"><label class="form-label">নতুন পাসওয়ার্ড</label><input type="password" name="new_password" class="form-control" required></div>
        <div class="mb-3"><label class="form-label">নতুন পাসওয়ার্ড নিশ্চিত করুন</label><input type="password" name="confirm_password" class="form-control" required></div>
        <button type="submit" name="change_password" class="btn btn-primary w-100">পরিবর্তন করুন</button>
    </form>
</div></div></body></html>