<?php
$page_title = "API গেটওয়ে ম্যানেজমেন্ট";
require_once 'includes/auth_check.php';
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['set_active'])) {
        $active_id = (int)$_POST['active_gateway'];
        $conn->query("UPDATE api_gateways SET is_active = 0"); // Deactivate all
        $conn->query("UPDATE api_gateways SET is_active = 1 WHERE id = $active_id"); // Activate selected
    } else {
        $gateway_id = (int)$_POST['gateway_id'];
        $api_key = $_POST['api_key'];
        $secret_key = $_POST['secret_key'];
        $api_url = $_POST['api_url'];
        $status_url = $_POST['status_url'];
        $stmt = $conn->prepare("UPDATE api_gateways SET api_key=?, secret_key=?, api_url=?, status_url=? WHERE id=?");
        $stmt->bind_param("ssssi", $api_key, $secret_key, $api_url, $status_url, $gateway_id);
        $stmt->execute();
    }
    $message = '<div class="alert alert-success">সেটিংস সফলভাবে সেভ হয়েছে।</div>';
}

$gateways = $conn->query("SELECT * FROM api_gateways");
include 'includes/header.php';
?>
<div class="container-fluid">
    <h2 class="mb-4">API গেটওয়ে ম্যানেজমেন্ট</h2><?php echo $message; ?>
    <div class="card mb-4"><div class="card-body">
        <form method="POST">
            <h5>فعال রিচার্জ গেটওয়ে নির্বাচন করুন</h5>
            <select name="active_gateway" class="form-select">
                <?php mysqli_data_seek($gateways, 0); while($gw = $gateways->fetch_assoc()): ?>
                <option value="<?php echo $gw['id']; ?>" <?php if($gw['is_active']) echo 'selected'; ?>><?php echo htmlspecialchars($gw['gateway_name']); ?></option>
                <?php endwhile; ?>
            </select>
            <button type="submit" name="set_active" class="btn btn-primary mt-2">فعال করুন</button>
        </form>
    </div></div>

    <?php mysqli_data_seek($gateways, 0); while($gateway = $gateways->fetch_assoc()): ?>
    <div class="card mb-3"><div class="card-header"><h5><?php echo htmlspecialchars($gateway['gateway_name']); ?> সেটিংস</h5></div><div class="card-body">
        <form method="POST">
            <input type="hidden" name="gateway_id" value="<?php echo $gateway['id']; ?>">
            <div class="mb-3"><label class="form-label">API Key / Username</label><input type="text" name="api_key" class="form-control" value="<?php echo htmlspecialchars($gateway['api_key'] ?? ''); ?>"></div>
            <div class="mb-3"><label class="form-label">Secret Key / Password / Token</label><input type="text" name="secret_key" class="form-control" value="<?php echo htmlspecialchars($gateway['secret_key'] ?? ''); ?>"></div>
            <div class="mb-3"><label class="form-label">API URL (রিচার্জ/পেমেন্ট)</label><input type="text" name="api_url" class="form-control" value="<?php echo htmlspecialchars($gateway['api_url'] ?? ''); ?>"></div>
            <div class="mb-3"><label class="form-label">API URL (স্ট্যাটাস/ব্যালেন্স)</label><input type="text" name="status_url" class="form-control" value="<?php echo htmlspecialchars($gateway['status_url'] ?? ''); ?>"></div>
            <button type="submit" class="btn btn-success">সেভ</button>
        </form>
    </div></div>
    <?php endwhile; ?>
</div>
<?php include 'includes/footer.php'; $conn->close(); ?>