<?php
// 1. Include the database connection file
require_once 'includes/db_connect.php';

// 2. Fetch all site settings from the database
$settings_res = $conn->query("SELECT * FROM settings");
$settings = [];
while ($row = $settings_res->fetch_assoc()) {
    $settings[$row['setting_name']] = $row['setting_value'];
}

// 3. Security Redirects: If a user or admin is already logged in, redirect them.
if (isset($_SESSION['user_id'])) {
    header("location: index.php");
    exit;
}
if (isset($_SESSION['admin_id'])) {
    header("location: admin/index.php");
    exit;
}

// 4. Handle Login Form Submission Logic
$message = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $mobile = trim($_POST['mobile']);
    $password = $_POST['password'];

    if (empty($mobile) || empty($password)) {
        $message = '<div class="alert alert-danger">মোবাইল নম্বর ও পাসওয়ার্ড দিন।</div>';
    } else {
        $stmt = $conn->prepare("SELECT id, full_name, password, role, status FROM users WHERE mobile = ?");
        $stmt->bind_param("s", $mobile);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();

            // Check if the account is inactive/blocked
            if ($user['status'] == 'Inactive') {
                $message = '<div class="alert alert-danger">আপনার একাউন্টটি নিষ্ক্রিয় করা হয়েছে। সাপোর্টে যোগাযোগ করুন।</div>';
            
            // Verify the password
            } elseif (password_verify($password, $user['password'])) {
                // If password is correct, check the role for redirection
                if ($user['role'] == 'admin') {
                    $_SESSION['admin_id'] = $user['id'];
                    $_SESSION['admin_name'] = $user['full_name'];
                    header("location: admin/index.php");
                } else {
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['full_name'] = $user['full_name'];
                    $_SESSION['mobile'] = $user['mobile'];
                    header("location: index.php");
                }
                exit; // Stop script execution after redirect
            } else {
                $message = '<div class="alert alert-danger">আপনার দেওয়া পাসওয়ার্ডটি সঠিক নয়।</div>';
            }
        } else {
            $message = '<div class="alert alert-danger">এই মোবাইল নম্বর দিয়ে কোনো একাউন্ট খুঁজে পাওয়া যায়নি।</div>';
        }
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>লগইন - <?php echo htmlspecialchars($settings['site_name']); ?></title>
    <link rel="icon" href="<?php echo htmlspecialchars($settings['site_favicon']); ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f0f2f5; font-family: 'Noto Sans Bengali', sans-serif; }
        .form-container { 
            max-width: 400px; 
            margin: 60px auto; 
            padding: 30px; 
            background: #fff; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.1); 
            border-radius: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="form-container">
            
            <div class="text-center mb-4">
                <a href="index.php">
                    <img src="<?php echo htmlspecialchars($settings['site_logo']); ?>" alt="Site Logo" style="max-height: 60px;">
                </a>
            </div>

            <div class="text-center">
                <h2>স্বাগতম!</h2>
                <p class="text-muted">আপনার একাউন্টে লগইন করুন।</p>
            </div>
            
            <?php if(!empty($message)) echo $message; ?>
            
            <form action="login.php" method="post" class="mt-4">
                <div class="form-floating mb-3">
                    <input type="tel" name="mobile" class="form-control" id="floatingMobile" placeholder="মোবাইল নম্বর" required>
                    <label for="floatingMobile">মোবাইল নম্বর</label>
                </div>
                <div class="form-floating mb-3">
                    <input type="password" name="password" class="form-control" id="floatingPassword" placeholder="পাসওয়ার্ড" required>
                    <label for="floatingPassword">পাসওয়ার্ড</label>
                </div>
                <div class="text-end mt-2 mb-3">
                    <a href="forgot_password.php" class="small">পাসওয়ার্ড ভুলে গেছেন?</a>
                </div>
                <button type="submit" class="btn btn-primary w-100 py-2">লগইন করুন</button>
            </form>
            <div class="mt-3 text-center">
                <p>একাউন্ট নেই? <a href="register.php">নতুন একাউন্ট খুলুন</a></p>
            </div>
        </div>
    </div>
</body>
</html>