<?php
// Include the database connection file, which also starts the session.
require_once 'includes/db_connect.php';

// Security Check: If the user is not logged in, redirect them to the login page.
if (!isset($_SESSION["user_id"])) {
    header("location: login.php");
    exit;
}

// Get the logged-in user's ID from the session.
$user_id = $_SESSION['user_id'];

// --- Step 1: Fetch all notifications for the current user ---
// We order them by creation date to show the newest notifications first.
$notifications = [];
$stmt = $conn->prepare("SELECT id, title, message, is_read, created_at FROM notifications WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $notifications[] = $row;
    }
}
$stmt->close();

// --- Step 2: Mark all unread notifications as read ---
// As soon as the user opens their inbox, we update their unread messages to 'read' (is_read = 1).
// This will make the unread count on the homepage disappear.
$conn->query("UPDATE notifications SET is_read = 1 WHERE user_id = $user_id AND is_read = 0");

$conn->close();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ইনবক্স</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        body { background-color: #f4f7fa; font-family: 'Noto Sans Bengali', sans-serif; }
    </style>
</head>
<body>
    <div class="container my-4" style="max-width: 700px;">
        <div class="d-flex align-items-center mb-4">
            <a href="index.php" class="text-dark fs-4 me-3 text-decoration-none"><i class="fas fa-arrow-left"></i></a>
            <h3 class="mb-0">ইনবক্স</h3>
        </div>

        <div class="list-group shadow-sm">
            <?php if (empty($notifications)): ?>
                <div class="list-group-item">
                    <p class="text-center text-muted my-5">আপনার ইনবক্স খালি।</p>
                </div>
            <?php else: ?>
                <?php foreach ($notifications as $notification): ?>
                    <div class="list-group-item list-group-item-action <?php if($notification['is_read'] == 0) echo 'list-group-item-light fw-bold'; ?>">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1 fs-6"><?php echo htmlspecialchars($notification['title']); ?></h5>
                            <small class="text-muted"><?php echo date("d M, Y, h:i A", strtotime($notification['created_at'])); ?></small>
                        </div>
                        <p class="mb-1 small"><?php echo htmlspecialchars($notification['message']); ?></p>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>