<?php
header('Content-Type: application/json');
require_once '../includes/db_connect.php';

// Only allow logged-in users to access this
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$response = ['status' => 'error', 'message' => 'Invalid request'];

if (isset($_POST['mobile'])) {
    $mobile = trim($_POST['mobile']);
    
    // Prevent user from sending to themselves
    if ($mobile == $_SESSION['mobile']) {
        $response = ['status' => 'error', 'message' => 'আপনি নিজের একাউন্টে টাকা পাঠাতে পারবেন না।'];
    } else {
        $stmt = $conn->prepare("SELECT full_name FROM users WHERE mobile = ? AND role = 'user'");
        $stmt->bind_param("s", $mobile);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            $response = ['status' => 'success', 'name' => $user['full_name']];
        } else {
            $response = ['status' => 'error', 'message' => 'এই নম্বরে কোনো একাউন্ট খুঁজে পাওয়া যায়নি।'];
        }
        $stmt->close();
    }
}
$conn->close();
echo json_encode($response);
?>