<?php
$page_title = "সকল লেনদেন";
require_once 'includes/auth_check.php';
include 'includes/header.php';

// Initialize filter variables
$search_user = $_GET['search_user'] ?? '';
$txn_type = $_GET['txn_type'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';

// Base SQL query
$sql = "SELECT t.*, u.full_name, u.mobile 
        FROM transactions t 
        JOIN users u ON t.user_id = u.id 
        WHERE 1=1"; // Start with a condition that's always true

$params = [];
$types = '';

// Append filters to the query if they are set
if (!empty($search_user)) {
    $sql .= " AND (u.full_name LIKE ? OR u.mobile LIKE ?)";
    $params[] = "%" . $search_user . "%";
    $params[] = "%" . $search_user . "%";
    $types .= 'ss';
}
if (!empty($txn_type)) {
    $sql .= " AND t.type = ?";
    $params[] = $txn_type;
    $types .= 's';
}
if (!empty($start_date)) {
    $sql .= " AND DATE(t.created_at) >= ?";
    $params[] = $start_date;
    $types .= 's';
}
if (!empty($end_date)) {
    $sql .= " AND DATE(t.created_at) <= ?";
    $params[] = $end_date;
    $types .= 's';
}

$sql .= " ORDER BY t.created_at DESC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$transactions_result = $stmt->get_result();

// Get unique transaction types for the filter dropdown
$types_result = $conn->query("SELECT DISTINCT type FROM transactions ORDER BY type ASC");

?>

<div class="container-fluid">
    <h2 class="mb-4">সকল লেনদেনের ইতিহাস</h2>

    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="transactions.php" class="row g-3 align-items-end">
                <div class="col-md-3">
                    <label for="search_user" class="form-label">ইউজার (নাম/মোবাইল)</label>
                    <input type="text" id="search_user" name="search_user" class="form-control" value="<?php echo htmlspecialchars($search_user); ?>">
                </div>
                <div class="col-md-3">
                    <label for="txn_type" class="form-label">লেনদেনের ধরন</label>
                    <select id="txn_type" name="txn_type" class="form-select">
                        <option value="">সব ধরন</option>
                        <?php while($type_row = $types_result->fetch_assoc()): ?>
                            <option value="<?php echo $type_row['type']; ?>" <?php if ($txn_type == $type_row['type']) echo 'selected'; ?>>
                                <?php echo htmlspecialchars($type_row['type']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="start_date" class="form-label">শুরুর তারিখ</label>
                    <input type="date" id="start_date" name="start_date" class="form-control" value="<?php echo htmlspecialchars($start_date); ?>">
                </div>
                <div class="col-md-2">
                    <label for="end_date" class="form-label">শেষ তারিখ</label>
                    <input type="date" id="end_date" name="end_date" class="form-control" value="<?php echo htmlspecialchars($end_date); ?>">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100">ফিল্টার</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-light">
                        <tr>
                            <th>Trx ID</th>
                            <th>ইউজার</th>
                            <th>মোবাইল</th>
                            <th>ধরন</th>
                            <th>পরিমাণ (৳)</th>
                            <th>বিবরণ</th>
                            <th>সময়</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($transactions_result->num_rows > 0): ?>
                            <?php while($txn = $transactions_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $txn['id']; ?></td>
                                    <td><?php echo htmlspecialchars($txn['full_name']); ?></td>
                                    <td><?php echo htmlspecialchars($txn['mobile']); ?></td>
                                    <td><span class="badge bg-secondary"><?php echo htmlspecialchars($txn['type']); ?></span></td>
                                    <td><?php echo number_format($txn['amount'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($txn['description']); ?></td>
                                    <td><?php echo date("d M, Y h:i A", strtotime($txn['created_at'])); ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">এই ফিল্টারে কোনো লেনদেন পাওয়া যায়নি।</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
$stmt->close();
$conn->close();
?>