<?php
$page_title = "অফার ম্যানেজমেন্ট";
require_once 'includes/auth_check.php';
include 'includes/header.php';

$offers_result = $conn->query("SELECT * FROM offers ORDER BY id DESC");
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>সকল অফার</h2>
        <a href="add_edit_offer.php" class="btn btn-primary"><i class="fas fa-plus"></i> নতুন অফার যোগ করুন</a>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>অফারের নাম</th>
                            <th>অপারেটর</th>
                            <th>মূল্য (৳)</th>
                            <th>ধরন</th>
                            <th>স্ট্যাটাস</th>
                            <th>একশন</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($offers_result->num_rows > 0): ?>
                            <?php while($offer = $offers_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $offer['id']; ?></td>
                                    <td><?php echo htmlspecialchars($offer['offer_name']); ?></td>
                                    <td><?php echo htmlspecialchars($offer['operator']); ?></td>
                                    <td><?php echo number_format($offer['price'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($offer['offer_type']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $offer['status'] == 'Active' ? 'success' : 'danger'; ?>">
                                            <?php echo $offer['status']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="add_edit_offer.php?id=<?php echo $offer['id']; ?>" class="btn btn-sm btn-info">
                                            <i class="fas fa-edit"></i> এডিট
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="7" class="text-center">কোনো অফার পাওয়া যায়নি।</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
$conn->close();
?>