<?php
$page_title = "অফার কমিশন";
require_once 'includes/auth_check.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['offer_id'])) {
    $offer_id = $_POST['offer_id'];
    $discounts = $_POST['discounts'];

    foreach ($discounts as $level_id => $discount) {
        $discount = (float)$discount;
        // UPSERT logic: Insert if not exists, update if exists
        $conn->query("INSERT INTO offer_commissions (offer_id, level_id, discount) VALUES ($offer_id, $level_id, $discount) ON DUPLICATE KEY UPDATE discount=$discount");
    }
}

$offers = $conn->query("SELECT id, offer_name FROM offers ORDER BY offer_name ASC");
$levels = $conn->query("SELECT id, level_name FROM reseller_levels ORDER BY rank ASC");

include 'includes/header.php';
?>
<div class="container-fluid">
    <h2 class="mb-4">অফারের জন্য কমিশন সেট করুন</h2>
    <div class="card">
        <div class="card-body">
            <form method="GET" class="mb-4">
                <label for="offer_select" class="form-label">একটি অফার সিলেক্ট করুন</label>
                <div class="input-group">
                    <select id="offer_select" name="offer_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- অফার বাছাই করুন --</option>
                        <?php while ($offer = $offers->fetch_assoc()): ?>
                            <option value="<?php echo $offer['id']; ?>" <?php if(isset($_GET['offer_id']) && $_GET['offer_id'] == $offer['id']) echo 'selected'; ?>>
                                <?php echo htmlspecialchars($offer['offer_name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
            </form>

            <?php if (isset($_GET['offer_id']) && !empty($_GET['offer_id'])): 
                $selected_offer_id = (int)$_GET['offer_id'];
                // Fetch existing commissions for this offer
                $commissions_res = $conn->query("SELECT level_id, discount FROM offer_commissions WHERE offer_id = $selected_offer_id");
                $existing_commissions = [];
                while ($c = $commissions_res->fetch_assoc()) {
                    $existing_commissions[$c['level_id']] = $c['discount'];
                }
            ?>
                <hr>
                <form method="POST" action="">
                    <input type="hidden" name="offer_id" value="<?php echo $selected_offer_id; ?>">
                    <h5>কমিশন/ডিসকাউন্ট সেট করুন:</h5>
                    <table class="table">
                        <thead><tr><th>লেভেল</th><th>ডিসকাউন্ট (৳)</th></tr></thead>
                        <tbody>
                            <?php mysqli_data_seek($levels, 0); // Reset pointer ?>
                            <?php while ($level = $levels->fetch_assoc()): 
                                $current_discount = $existing_commissions[$level['id']] ?? 0;
                            ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($level['level_name']); ?></td>
                                    <td>
                                        <input type="number" step="0.01" name="discounts[<?php echo $level['id']; ?>]" class="form-control" value="<?php echo $current_discount; ?>">
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <button type="submit" class="btn btn-success">সেভ করুন</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php
include 'includes/footer.php';
$conn->close();
?>