<?php
// Start the session on every secure admin page
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 1. Security Check: If the admin is not logged in, redirect to the login page.
if (!isset($_SESSION['admin_id'])) {
    // Since this file is in 'admin/includes/', the login page is one level up.
    header("location: login.php");
    exit;
}

// 2. Database Connection: Include the main database connection file.
// The path is '../../' because this file is in 'admin/includes/' and db_connect.php is in the root 'includes/' folder.
// This path is CRITICAL and often causes errors.
require_once __DIR__ . '/../../includes/db_connect.php';

// 3. ===== DEBUGGING CHECK =====
// Immediately check if the $conn variable was created successfully.
if (!isset($conn) || $conn->connect_error) {
    die("মারাত্মক সমস্যা: db_connect.php ফাইল থেকে ডাটাবেজ কানেকশন (\$conn) সঠিকভাবে লোড হয়নি। অনুগ্রহ করে `auth_check.php` ফাইলের ভেতরে `require_once` এর পাথ (`../../includes/db_connect.php`) এবং `db_connect.php` ফাইলের ডাটাবেজ তথ্য চেক করুন।");
}
// ===== END DEBUGGING CHECK =====

/**
 * 4. Activity Logging Function
 * Logs an admin's action into the database.
 */
function log_activity($conn, $admin_id, $action, $details = '') {
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $stmt = $conn->prepare("INSERT INTO admin_activity_log (admin_id, action, details, ip_address) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("isss", $admin_id, $action, $details, $ip_address);
    $stmt->execute();
    $stmt->close();
}
function create_notification($conn, $user_id, $title, $message) {
    $stmt = $conn->prepare("INSERT INTO notifications (user_id, title, message) VALUES (?, ?, ?)");
    $stmt->bind_param("iss", $user_id, $title, $message);
    $stmt->execute();
    $stmt->close();
}
?>